<?php
/*----------------------------------------------------------------------
# Package - JM Template
# ----------------------------------------------------------------------
# Author - JoomlaMan http://www.joomlaman.com
# Copyright Copyright under commercial licence (C) 2012 - 2013 JoomlaMan
#license http://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3
-----------------------------------------------------------------------*/

/**
 * Helix Framework Credit
 * Template Name - Shaper Helix
 * Template Version 1.0.0
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 20010 - 2013 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die;
if(!class_exists("Exp")){
    require_once(dirname(__FILE__).'/lib/lib.php');
}
$this->helix = Helix::getInstance();

if (!isset($this->error))
{
    $this->error = JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
    $this->debug = false;
}
//get language and direction
$doc = JFactory::getDocument();
$this->language = $doc->language;
$this->direction = $doc->direction;

$this->helix->getDocument()->setTitle($this->error->getCode() . ' - '.$this->title);

$this->helix->header()->addLess('error', 'error');

require_once(JPATH_LIBRARIES.'/joomla/document/html/renderer/head.php');
$header_renderer = new JDocumentRendererHead($doc);
$header_contents = $header_renderer->render(null);
    
?><!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"  lang="<?php echo $this->language; ?>"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"  lang="<?php echo $this->language; ?>"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"  lang="<?php echo $this->language; ?>"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="<?php echo $this->language; ?>"> <!--<![endif]-->
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <?php echo $header_contents; ?>
    <link href='http://fonts.googleapis.com/css?family=Open+Sans:700,400,300' rel='stylesheet' type='text/css' />
</head>
<body<?php echo $this->helix->bodyClass('bg clearfix error_bg'); ?>>
    <div id="frame_error" class="container">
        <div id="errorDescription" class="row-fluid">
            <div id="spman" class="span6">
                <img alt="" src="<?php echo $this->baseurl ?>/templates/<?php echo $this->template ?>/images/spman.png" />
            </div>
            <div id="inforight" class="span6">
                <div id="ifinner">
                    <h1 class="page-error">4<span>0</span>4</h1>
                    <h2 class="page-error jm-error jm-bg"><?php echo $this->error->getMessage(); ?></h2>
                    <div id="errorboxbody">
                        <span class="page-error jm-color jm-error jm-font-size"><?php echo JText::_('JM_LANG_ERROR_OOOPS'); ?></span>
                        <span class="page-error jm-error jm-font-size"><?php echo JText::_('JM_LANG_ERROR_DESC'); ?></span>
                    </div>
                    <div class="to-homepage">
                        <span class="jm-font-size"><a class="gohome btn btn-default btn-" href="<?php echo $this->baseurl; ?>/index.php" title="<?php echo JText::_('JERROR_LAYOUT_GO_TO_THE_HOME_PAGE'); ?>"><?php echo JText::_('JM_LAYOUT_HOME_PAGE'); ?></a></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>