<?php
/**
 * @version   $Id: item.php 1812 2013-01-14 18:45:06Z lefteris.kavadas $
 * @package   K2
 * @author    JoomlaWorks http://www.joomlaworks.net
 * @copyright Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.
 * @license   GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

?>

<?php if(JRequest::getInt('print')==1): ?>
<!-- Print button at the top of the print page only -->
<a class="itemPrintThisPage" rel="nofollow" href="#" onclick="window.print();return false;">
  <span><?php echo JText::_('K2_PRINT_THIS_PAGE'); ?></span>
</a>
<?php endif; ?>

<!-- Start K2 Item Layout -->
<span id="startOfPageId<?php echo JRequest::getInt('id'); ?>"></span>

<div id="k2Container" class="itemPortfolio itemView<?php echo ($this->item->featured) ? ' itemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">

  <!-- Plugins: BeforeDisplay -->
  <?php echo $this->item->event->BeforeDisplay; ?>

  <!-- K2 Plugins: K2BeforeDisplay -->
  <?php echo $this->item->event->K2BeforeDisplay; ?>

  <div class="catItemHeader">
         <?php if($this->item->params->get('catItemTitle')): ?>
        <!-- Item title -->
        <h3 class="catItemTitle">
              <?php if(isset($this->item->editLink)): ?>
              <!-- Item edit link -->
              <span class="catItemEditLink">
                  <a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
                      <?php echo JText::_('K2_EDIT_ITEM'); ?>
                  </a>
              </span>
              <?php endif; ?>

          <?php if ($this->item->params->get('catItemTitleLinked')): ?>
              <a href="<?php echo $this->item->link; ?>">
              <?php echo $this->item->title; ?>
          </a>
          <?php else: ?>
          <?php echo $this->item->title; ?>
          <?php endif; ?>

          <?php if($this->item->params->get('catItemFeaturedNotice') && $this->item->featured): ?>

          <!-- Featured flag -->
          <span>
              <sup>
                  <?php echo JText::_('K2_FEATURED'); ?>
              </sup>
          </span>
          <?php endif; ?>

          <?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
            <!-- Item navigation -->
            <div class="itemNavigation clearfix">
              <span class="itemNavigationTitle"><?php //echo JText::_('K2_MORE_IN_THIS_CATEGORY'); ?></span>

              <?php if(isset($this->item->previousLink)): ?>
              <a class="itemPrevious" href="<?php echo $this->item->previousLink; ?>">
                <i class="icon-chevron-left"></i>
              </a>
              <?php endif; ?>

              <?php if(isset($this->item->nextLink)): ?>
              <a class="itemNext" href="<?php echo $this->item->nextLink; ?>">
                <i class="icon-chevron-right"></i>
              </a>
              <?php endif; ?>
            </div>
          <?php endif; ?>
        </h3>

        <div class="catItemMeta">
            <?php if($this->item->params->get('catItemDateCreated')): ?>
            <!-- Date created -->
            <span class="catItemDateCreated">
                <i class="fa-clock-o fa"></i><?php echo JHTML::_('date', $this->item->created , JText::_('K2_DATE_FORMAT_LC2')); ?>
            </span>
            <?php endif; ?>
        <?php endif; ?>

         <?php if($this->item->params->get('catItemCommentsAnchor') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1')) ): ?>
          <!-- Anchor link to comments below -->
        
        <?php endif; ?>
        
        <?php if($this->item->params->get('catItemAuthor')): ?>
        <!-- Item Author -->
        <span class="catItemAuthor">
            <?php //echo K2HelperUtilities::writtenBy($this->item->author->profile->gender); ?> 
            <?php if(isset($this->item->author->link) && $this->item->author->link): ?>
            <i class="fa-user fa"></i><a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
            <?php else: ?>
            <?php echo $this->item->author->name; ?>
            <?php endif; ?>
        </span>
        <?php endif; ?>

        <?php if($this->item->params->get('catItemCategory')): ?>
        <!-- Item category name -->
        <span class="catItemCategory">
            <i class="fa-bookmark fa"></i><a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
        </span>
        <?php endif; ?>
        
        </div><!-- End Item Meta -->
  </div><!-- catItemHeader -->

  <!-- Plugins: AfterDisplayTitle -->
  <?php echo $this->item->event->AfterDisplayTitle; ?>

  <!-- K2 Plugins: K2AfterDisplayTitle -->
  <?php echo $this->item->event->K2AfterDisplayTitle; ?>

  <?php if(
    $this->item->params->get('itemFontResizer') ||
    $this->item->params->get('itemPrintButton') ||
    $this->item->params->get('itemEmailButton') ||
    $this->item->params->get('itemSocialButton') ||
    $this->item->params->get('itemVideoAnchor') ||
    $this->item->params->get('itemImageGalleryAnchor') ||
    $this->item->params->get('itemCommentsAnchor')
  ): ?>
  
  <?php endif; ?>

  <?php if($this->item->params->get('itemRating')): ?>
  <!-- Item Rating -->
  
  <?php endif; ?>

  <div class="itemBody clearfix">
    <div class="itemPortfolio-left span8">
      <!-- Plugins: BeforeDisplayContent -->
      <?php echo $this->item->event->BeforeDisplayContent; ?>

      <!-- K2 Plugins: K2BeforeDisplayContent -->
      <?php echo $this->item->event->K2BeforeDisplayContent; ?>

      <?php if($this->item->params->get('itemImage') && !empty($this->item->image)): ?>
      <!-- Item Image -->
      <div class="itemImageBlock">
        <span class="itemImage">
          <a class="modal" rel="{handler: 'image'}" href="<?php echo $this->item->imageXLarge; ?>" title="<?php echo JText::_('K2_CLICK_TO_PREVIEW_IMAGE'); ?>">
            <img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" style="width:<?php echo $this->item->imageWidth; ?>px; height:auto;" />
          </a>
        </span>

        <?php if($this->item->params->get('itemImageMainCaption') && !empty($this->item->image_caption)): ?>
        <!-- Image caption -->
        <span class="itemImageCaption"><?php echo $this->item->image_caption; ?></span>
        <?php endif; ?>

        <?php if($this->item->params->get('itemImageMainCredits') && !empty($this->item->image_credits)): ?>
        <!-- Image credits -->
        <span class="itemImageCredits"><?php echo $this->item->image_credits; ?></span>
        <?php endif; ?>

        <div class="clr"></div>
      </div>
      <?php endif; ?>

      <?php if($this->item->params->get('itemImageGallery') && !empty($this->item->gallery)): ?>
      <!-- Item image gallery -->
      <a name="itemImageGalleryAnchor" id="itemImageGalleryAnchor"></a>
      <div class="itemImageGallery">
        <?php echo $this->item->gallery; ?>
      </div>
      <?php endif; ?>

      <?php if($this->item->params->get('itemVideo') && !empty($this->item->video)): ?>
        <!-- Item video -->
        <a name="itemVideoAnchor" id="itemVideoAnchor"></a>

        <div class="itemVideoBlock">
          <?php if($this->item->videoType=='embedded'): ?>
          <div class="itemVideoEmbedded">
            <?php echo $this->item->video; ?>
          </div>
          <?php else: ?>
          <span class="itemVideo"><?php echo $this->item->video; ?></span>
          <?php endif; ?>

          <?php if($this->item->params->get('itemVideoCaption') && !empty($this->item->video_caption)): ?>
          <span class="itemVideoCaption"><?php echo $this->item->video_caption; ?></span>
          <?php endif; ?>

          <?php if($this->item->params->get('itemVideoCredits') && !empty($this->item->video_credits)): ?>
          <span class="itemVideoCredits"><?php echo $this->item->video_credits; ?></span>
          <?php endif; ?>

          <div class="clr"></div>
        </div>
        <?php endif; ?>

    </div><!-- End. itemPortfolio-left -->

    <div class="itemPortfolio-right span4">
      <?php if(!empty($this->item->fulltext)): ?>
      <?php if($this->item->params->get('itemIntroText')): ?>
      <!-- Item introtext -->
      <div class="itemIntroText">
        <?php echo $this->item->introtext; ?>
      </div>
      <?php endif; ?>
      <?php if($this->item->params->get('itemFullText')): ?>
      <!-- Item fulltext -->
      <div class="itemFullText">
        <h4 class="entry-title"><?php echo JText::_('JM_K2_ABOUT_PROJECT'); ?></h4>
        <?php echo $this->item->fulltext; ?>
      </div>
      <?php endif; ?>
      <?php else: ?>
      <!-- Item text -->
      <div class="itemFullText">
        <h4 class="entry-title"><?php echo JText::_('JM_K2_ABOUT_PROJECT'); ?></h4>
        <?php echo $this->item->introtext; ?>
      </div>
      <?php endif; ?>

      <div class="clr"></div>

      <?php if($this->item->params->get('itemExtraFields') && count($this->item->extra_fields)): ?>
      <!-- Item extra fields -->
      <div class="itemExtraFields">
        <h4 class="entry-title"><?php echo JText::_('JM_K2_ADDITIONAL_INFO'); ?></h4>
        <ul>
        <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
        <?php if($extraField->value != ''): ?>
        <li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
          <?php if($extraField->type == 'header'): ?>
          <h4 class="itemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
          <?php else: ?>
          <span class="itemExtraFieldsLabel"><?php echo $extraField->name; ?>:</span>
          <?php if($extraField->type == 'multipleSelect'): 
              
                $value = explode(', ', $extraField->value);
                $str = $extraField->value;
                $chars=str_split($str);
                $count=0;
                foreach($chars as &$char){ if ($char==','){$count++;}}
                echo '<ul class="style-list unstyled check-sign">';
                    for($i=0; $i <= $count; $i++) echo '<li>'.$value[$i].'</li>';
                echo '</ul>';
              ?>
              <?php elseif($extraField->type == 'link'): ?>
                <span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span>
              <?php elseif($extraField->type != 'date'): ?>
                <span class="itemExtraFieldsValue"><?php echo $extraField->value; ?></span>
              <?php else: ?>
                <span class="itemExtraFieldsValue"><?php echo JHTML::_('date', $extraField->value , JText::_('d F Y')); ?></span>
              <?php endif; ?>
          <?php endif; ?>
        </li>
        <?php endif; ?>
        <?php endforeach; ?>
        </ul>
        <div class="clr"></div>
      </div>
      <?php endif; ?>

     

      <!-- Plugins: AfterDisplayContent -->
      <?php echo $this->item->event->AfterDisplayContent; ?>

      <!-- K2 Plugins: K2AfterDisplayContent -->
      <?php echo $this->item->event->K2AfterDisplayContent; ?>

      <div class="clr"></div>

    <?php if($this->item->params->get('itemTwitterButton',1) || $this->item->params->get('itemFacebookButton',1) || $this->item->params->get('itemGooglePlusOneButton',1)): ?>
    <!-- Social sharing -->
    <div class="line-social"></div>
    <div class="itemSocialSharing">

      <?php if($this->item->params->get('itemTwitterButton',1)): ?>
      <!-- Twitter Button -->
      <div class="itemTwitterButton">
        <a href="https://twitter.com/share" class="twitter-share-button" data-count="horizontal"<?php if($this->item->params->get('twitterUsername')): ?> data-via="<?php echo $this->item->params->get('twitterUsername'); ?>"<?php endif; ?>>
          <?php echo JText::_('K2_TWEET'); ?>
        </a>
        <script type="text/javascript" src="//platform.twitter.com/widgets.js"></script>
      </div>
      <?php endif; ?>

      <?php if($this->item->params->get('itemFacebookButton',1)): ?>
      <!-- Facebook Button -->
      <div class="itemFacebookButton">
        <div id="fb-root"></div>
        <script type="text/javascript">
          (function(d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s); js.id = id;
            js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
            fjs.parentNode.insertBefore(js, fjs);
          }(document, 'script', 'facebook-jssdk'));
        </script>
        <div class="fb-like" data-send="false" data-width="200" data-show-faces="true"></div>
      </div>
      <?php endif; ?>

      <?php if($this->item->params->get('itemGooglePlusOneButton',1)): ?>
      <!-- Google +1 Button -->
      <div class="itemGooglePlusOneButton">
        <g:plusone annotation="inline" width="120"></g:plusone>
        <script type="text/javascript">
          (function() {
            window.___gcfg = {lang: 'en'}; // Define button default language here
            var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
            po.src = 'https://apis.google.com/js/plusone.js';
            var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
          })();
        </script>
      </div>
      <?php endif; ?>

      <div class="clr"></div>
    </div>
 

   <?php if($this->item->params->get('itemHits') || ($this->item->params->get('itemDateModified') && intval($this->item->modified)!=0)): ?>
    <?php endif; ?>

  <?php endif; ?>

  <?php if($this->item->params->get('itemCategory') || $this->item->params->get('itemTags') || $this->item->params->get('itemAttachments')): ?>
  <div class="itemLinks">
    <?php if($this->item->params->get('itemHits')): ?>
      <!-- Item Hits -->
      <span class="itemHits">
        <?php echo JText::_('K2_READ'); ?>: <span class="color"><?php echo $this->item->hits; ?> <?php echo JText::_('K2_TIMES'); ?></span>
      </span>
      <?php endif; ?>
    <?php if($this->item->params->get('itemCategory')): ?>
    <!-- Item category -->
    <div class="itemCategory">
      <span><?php echo JText::_('K2_PUBLISHED_IN'); ?>: </span>
      <a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
    </div>
    <?php endif; ?>

    <?php if($this->item->params->get('itemRating')): ?>
          <!-- Item Rating -->
          <div class="itemRatingBlock fcicon">
              <div class="itemRatingForm">
                 <span class="itemRating-text"><?php echo JText::_('K2_RATE_THIS_ITEM'); ?>: </span>
          <ul class="itemRatingList">
                      <li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
                      <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
                      <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
                      <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
                      <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
                      <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
                  </ul>
                  <div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
                  <div class="clr"></div>
              </div>
              <div class="clr"></div>
          </div>
          <?php endif; ?>
          
    <?php if($this->item->params->get('itemTags') && count($this->item->tags)): ?>
    <!-- Item tags -->
    <div class="itemTagsBlock">
      <span><?php echo JText::_('K2_TAGGED_UNDER'); ?>: </span>
      <ul class="itemTags">
        <?php foreach ($this->item->tags as $tag): ?>
        <li><a class="tag-left" href="<?php echo $tag->link; ?>"><span class="tag-right"><?php echo $tag->name; ?></span></a></li>
        <?php endforeach; ?>
      </ul>
      <div class="clr"></div>
    </div>
    <?php endif; ?>

    <?php if($this->item->params->get('itemAttachments') && count($this->item->attachments)): ?>
    <!-- Item attachments -->
    <div class="itemAttachmentsBlock">
      <span><?php echo JText::_('K2_DOWNLOAD_ATTACHMENTS'); ?></span>
      <ul class="itemAttachments">
        <?php foreach ($this->item->attachments as $attachment): ?>
        <li>
          <a title="<?php echo K2HelperUtilities::cleanHtml($attachment->titleAttribute); ?>" href="<?php echo $attachment->link; ?>"><?php echo $attachment->title; ?></a>
          <?php if($this->item->params->get('itemAttachmentsCounter')): ?>
          <span>(<?php echo $attachment->hits; ?> <?php echo ($attachment->hits==1) ? JText::_('K2_DOWNLOAD') : JText::_('K2_DOWNLOADS'); ?>)</span>
          <?php endif; ?>
        </li>
        <?php endforeach; ?>
      </ul>
    </div>
    <?php endif; ?>

    <div class="clr"></div>
  </div>
  <?php endif; ?>

 </div><!-- End .itemBody container -->
  <?php
  /*
  Note regarding 'Related Items'!
  If you add:
  - the CSS rule 'overflow-x:scroll;' in the element div.itemRelated {…} in the k2.css
  - the class 'k2Scroller' to the ul element below
  - the classes 'k2ScrollerElement' and 'k2EqualHeights' to the li element inside the foreach loop below
  - the style attribute 'style="width:<?php echo $item->imageWidth; ?>px;"' to the li element inside the foreach loop below
  ...then your Related Items will be transformed into a vertical-scrolling block, inside which, all items have the same height (equal column heights). This can be very useful if you want to show your related articles or products with title/author/category/image etc., which would take a significant amount of space in the classic list-style display.
  */
  ?>

  <?php if($this->item->params->get('itemRelated') && isset($this->relatedItems)): ?>
  <!-- Related items by tag -->
  
  <?php endif; ?>

  <div class="clr"></div>


  <?php if($this->item->params->get('itemNavigation') && !JRequest::getCmd('print') && (isset($this->item->nextLink) || isset($this->item->previousLink))): ?>
  <!-- Item navigation -->
  <div class="itemNavigation">
    <span class="itemNavigationTitle"><?php echo JText::_('K2_MORE_IN_THIS_CATEGORY'); ?></span>

    <?php if(isset($this->item->previousLink)): ?>
    <a class="itemPrevious" href="<?php echo $this->item->previousLink; ?>">
      &laquo; <?php echo $this->item->previousTitle; ?>
    </a>
    <?php endif; ?>

    <?php if(isset($this->item->nextLink)): ?>
    <a class="itemNext" href="<?php echo $this->item->nextLink; ?>">
      <?php echo $this->item->nextTitle; ?> &raquo;
    </a>
    <?php endif; ?>

  </div>
  <?php endif; ?>

  <!-- Plugins: AfterDisplay -->
  <?php echo $this->item->event->AfterDisplay; ?>

  <!-- K2 Plugins: K2AfterDisplay -->
  <?php echo $this->item->event->K2AfterDisplay; ?>

  <?php if($this->item->params->get('itemComments') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1'))): ?>
  <!-- K2 Plugins: K2CommentsBlock -->
  <?php echo $this->item->event->K2CommentsBlock; ?>
  <?php endif; ?>

 <?php if($this->item->params->get('itemComments') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2')) && empty($this->item->event->K2CommentsBlock)): ?>
  <!-- Item comments -->
  <a name="itemCommentsAnchor" id="itemCommentsAnchor"></a>

  <div class="itemComments">

    <?php if($this->item->params->get('commentsFormPosition')=='above' && $this->item->params->get('itemComments') && !JRequest::getInt('print') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2' && K2HelperPermissions::canAddComment($this->item->catid)))): ?>
    <!-- Item comments form -->
    
    <?php endif; ?>
    <div class="boxCommentContent">
      <?php if($this->item->numOfComments>0 && $this->item->params->get('itemComments') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2'))): ?>
      <!-- Item user comments -->
      <h3 class="itemCommentsCounter">
        <span><?php echo $this->item->numOfComments; ?>&nbsp;<?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?></span> 
      </h3>

      <ul class="itemCommentsList">
        <?php foreach ($this->item->comments as $key=>$comment): ?>
        <li class="<?php echo ($key%2) ? "odd" : "even"; echo (!$this->item->created_by_alias && $comment->userID==$this->item->created_by) ? " authorResponse" : ""; echo($comment->published) ? '':' unpublishedComment'; ?>">
          <div class="itemCommentAvater k2-td">
          <?php if($comment->userImage): ?>
          <img src="<?php echo $comment->userImage; ?>" alt="<?php echo JFilterOutput::cleanText($comment->userName); ?>" width="<?php echo $this->item->params->get('commenterImgWidth'); ?>" />
          <?php endif; ?>
        </div>
        <div class="itemCommentContent k2-td">

          <span class="commentAuthorName">
            <?php echo JText::_('K2_POSTED_BY'); ?>
            <?php if(!empty($comment->userLink)): ?>
            <a href="<?php echo JFilterOutput::cleanText($comment->userLink); ?>" title="<?php echo JFilterOutput::cleanText($comment->userName); ?>" target="_blank" rel="nofollow">
              <?php echo $comment->userName; ?>
            </a>
            <?php else: ?>
            <?php echo $comment->userName; ?>
            <?php endif; ?>
          </span>

          <span class="commentDate">
            <?php echo JHTML::_('date', $comment->commentDate, JText::_('K2_DATE_FORMAT_LC2')); ?>
          </span>

          <p><?php echo $comment->commentText; ?></p>

          <?php if($this->inlineCommentsModeration || ($comment->published && ($this->params->get('commentsReporting')=='1' || ($this->params->get('commentsReporting')=='2' && !$this->user->guest)))): ?>
          <span class="commentToolbar">
            <?php if($this->inlineCommentsModeration): ?>
            <?php if(!$comment->published): ?>
            <a class="commentApproveLink" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=publish&commentID='.$comment->id.'&format=raw')?>"><?php echo JText::_('K2_APPROVE')?></a>
            <?php endif; ?>

            <a class="commentRemoveLink" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=remove&commentID='.$comment->id.'&format=raw')?>"><?php echo JText::_('K2_REMOVE')?></a>
            <?php endif; ?>

            <?php if($comment->published && ($this->params->get('commentsReporting')=='1' || ($this->params->get('commentsReporting')=='2' && !$this->user->guest))): ?>
            <a class="modal" rel="{handler:'iframe',size:{x:560,y:480}}" href="<?php echo JRoute::_('index.php?option=com_k2&view=comments&task=report&commentID='.$comment->id)?>"><?php echo JText::_('K2_REPORT')?></a>
            <?php endif; ?>

            <?php if($comment->reportUserLink): ?>
            <a class="k2ReportUserButton" href="<?php echo $comment->reportUserLink; ?>"><?php echo JText::_('K2_FLAG_AS_SPAMMER'); ?></a>
            <?php endif; ?>

          </span>
          <?php endif; ?>
        </div>
          <div class="clr"></div>
        </li>
        <?php endforeach; ?>
      </ul>
    </div>

    <div class="itemCommentsPagination">
      <?php echo $this->pagination->getPagesLinks(); ?>
    </div>
    <?php endif; ?>

    <?php $user = JFactory::getUser(); if ($this->item->params->get('comments') == '2' && $user->guest): ?>
        <div><?php echo JText::_('K2_LOGIN_TO_POST_COMMENTS'); ?></div>
    <?php endif; ?>

  </div>
  <?php endif; ?>

  <?php if($this->item->params->get('commentsFormPosition')=='below' && $this->item->params->get('itemComments') && !JRequest::getInt('print') && ($this->item->params->get('comments') == '1' || ($this->item->params->get('comments') == '2' && K2HelperPermissions::canAddComment($this->item->catid)))): ?>
    <!-- Item comments form -->
    <div class="itemCommentsForm">
      <?php echo $this->loadTemplate('comments_form'); ?>
    </div>
    <?php endif; ?>
  <?php if(!JRequest::getCmd('print')): ?>
  
  <?php endif; ?>
</div>
<!-- End K2 Item Layout -->
